# 브라우저 렌더링

**브라우저 렌더링**이란?

브라우저 렌더링은 웹 페이지를 사용자의 눈에 보이는 화면으로 변환하는 과정을 말한다. 즉 쉽게 말해 **웹 페이지의 내용을 브라우저 화면에 표시하는 과정**을 의미한다. 웹 페이지를 구성하는 HTML, CSS 및 JavaScript와 같은 웹 리소스를 해석하고, 브라우저 창에 그래픽으로 표시하는 과정을 포함한다.

![image-2.png](%E1%84%87%E1%85%B3%E1%84%85%E1%85%A1%E1%84%8B%E1%85%AE%E1%84%8C%E1%85%A5%20%E1%84%85%E1%85%A6%E1%86%AB%E1%84%83%E1%85%A5%E1%84%85%E1%85%B5%E1%86%BC%2095f2b2287a6145a68438812b7c9765a6/image-2.png)

위 사진은 브라우저 구성요소이다.

이 중 **렌더링 엔진**이 **브라우저 렌더링을 담당**하게 된다.

![스크린샷 2023-07-28 오후 5.48.13.png](%E1%84%87%E1%85%B3%E1%84%85%E1%85%A1%E1%84%8B%E1%85%AE%E1%84%8C%E1%85%A5%20%E1%84%85%E1%85%A6%E1%86%AB%E1%84%83%E1%85%A5%E1%84%85%E1%85%B5%E1%86%BC%2095f2b2287a6145a68438812b7c9765a6/%25EC%258A%25A4%25ED%2581%25AC%25EB%25A6%25B0%25EC%2583%25B7_2023-07-28_%25EC%2598%25A4%25ED%259B%2584_5.48.13.png)

위 사진과 같은 과정을 통해 브라우저 렌더링이 이루어진다. **DOM트리**, **CSS파서** 등을 기반으로 **렌더트리를 구축**해 결과적으로 **우리가 보는 화면을 구축하는 과정**을 의미한다.

DOM과 CSSOM 생성에 앞서

로더(Loader)가 서버로부터 전달받은 리소스 스트림을 읽는 과정이 발생한다.

그 이후 브라우저 렌더링 과정이 본격적으로 시작된다.

1. **DOM 트리 구축 :**

```html
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Document</title>
    <style>
    	ul{
        	color: red;
            background : black;
            font-size: 14px;
        }
        //li는 ul의 자식 노드인데 폰트 사이즈가 중복으로 기입.
        li{
       		font-size: 14px;
        }
        
        div{
        	display: none;
        }
</head>
<body>
	<ul>
    	<li>혜원</li>
        <li>브라우저 렌더링 공부</li>
    </ul>

</body>
</html>
```

라는 코드를 예를 들어보자. body 태그 안에 ul 태그, ul태그 하에 li 태그가 속해있는 것을 확인할 수 있다. 이러한 요소들을 tree형태로 만드는 것을

**DOM 트리 구축**이라고 한다. 이 때의 요소는 하나하나가 노드로 설정되어 트리 형태로 저장된다. 이렇게 만든 트리는 DOM 트리라고 한다.

참고로 DOM은 Document Object Model의 약자이다.

![image-3.png](%E1%84%87%E1%85%B3%E1%84%85%E1%85%A1%E1%84%8B%E1%85%AE%E1%84%8C%E1%85%A5%20%E1%84%85%E1%85%A6%E1%86%AB%E1%84%83%E1%85%A5%E1%84%85%E1%85%B5%E1%86%BC%2095f2b2287a6145a68438812b7c9765a6/image-3.png)

DOM Tree 구축 결과의 예는 위와 같다.

DOM Tree 구축과 **동시에** CSSOM 트리 구축이 진행된다.

1. **CSSOM 트리 구축**
    
    각각의 노드는 CSS 파서에 의해 정해진 **스타일 규칙**이 적용되어 있다. 예를 들어 span.color = "red"는 노드 색깔이 빨간색이라는 것을 알리는 규칙이다. 이런 것들을 기반으로 CSSOM이라는 트리가 만들어진다
    

![image-4.png](%E1%84%87%E1%85%B3%E1%84%85%E1%85%A1%E1%84%8B%E1%85%AE%E1%84%8C%E1%85%A5%20%E1%84%85%E1%85%A6%E1%86%AB%E1%84%83%E1%85%A5%E1%84%85%E1%85%B5%E1%86%BC%2095f2b2287a6145a68438812b7c9765a6/image-4.png)

위 사진과 같이 DOM Tree와 CSSOM 트리가 각각 동시에 구축된다.

1. **렌더 트리와 렌더 레이어 생성**
    
    앞에서 만든 DOM 트리와 CSSOM 트리를 각 요소에 맞게 합쳐 **랜더객체(Render Object)가 생성**된다. 그리고 이것들이 모여 렌더 트리가 생성된다.
    
    ![image-5.png](%E1%84%87%E1%85%B3%E1%84%85%E1%85%A1%E1%84%8B%E1%85%AE%E1%84%8C%E1%85%A5%20%E1%84%85%E1%85%A6%E1%86%AB%E1%84%83%E1%85%A5%E1%84%85%E1%85%B5%E1%86%BC%2095f2b2287a6145a68438812b7c9765a6/image-5.png)
    
    이전 사진에서는 DOM과 CSSOM이 각각 분리되어 있었으나 바로 위 사진에서 두 트리가 각 요소에 맞게 병렬적으로 합쳐진 것을 확인할 수 있다.
    
    이 과정에서 display:none이 포함된 노드는 지워지고,
    
    부모노드와 자식 노드에 중복으로 적힌 CSS 스타일은 부모노드에게만 위치하도록 설계하는 등의 최적화 과정을 거쳐 렌더 레이어가 완성된다. (위 코드에선 font-size가 ul과 li 태그에 중복으로 기입되었는데 렌터 트리와 렌더 레이어 생성 과정에서 이 중복 코드가 ul에만 적히게 된다.)
    
    (참고: visiblity:hidden은 요소는 있지만 빈 공간으로 둔다는 의미.
    
    display:none은 아예 사라지는 것으로 display: none만 이 과정에서 지워지게 된다.)
    
    위와 같은 렌더 레이어가 완성될 때 GPU에서 처리되는 부분(예를 들어 CSS3D/ video & cnavas / filter/ animation / transform : translateZ(0) 등)이 있으면 렌더 레이어에서 처리되지 않고
    
    따로 떼어내어 이 요소 각각을 강제적으로 그래픽 레이어(Graphic Layer)로 분리하게 된다.
    
    - Why? 렌더 레이어 과정이 일어나고 layout -> paint 과정이 일어나는데
        
        사용자가 중간에 클릭을하거나 드래그를 하는 등 요소가 바뀌면 layout과 paint 과정이 다시 발생한다. 이러한 과정을 reflow/repaint라고 하는데 이 과정이 많이 일어나면 브라우저에 부하가 발생한다. 따라서 변화가 많이 일어나는 것은 graphic layer로 따로 빼내서 처리한다.
        

![image-6.png](%E1%84%87%E1%85%B3%E1%84%85%E1%85%A1%E1%84%8B%E1%85%AE%E1%84%8C%E1%85%A5%20%E1%84%85%E1%85%A6%E1%86%AB%E1%84%83%E1%85%A5%E1%84%85%E1%85%B5%E1%86%BC%2095f2b2287a6145a68438812b7c9765a6/image-6.png)

1. 렌더 레이어를 대상으로 Layout 설정앞에서 만들어진 렌더 레이어를 가지고 레이아웃을 설정해준다.
2. 렌더 레이어를 대상으로 칠하기(paint)픽셀마다 점을 찍듯 칠한다. 이를 레스터화라고도 한다.
3. 레이어 합치기 및 표기각각의 레이어로부터 비트맵이 생성되고 GPU에 텍스처로 업로드된다. 그 다음 텍스처들은 서로 합쳐져 하나의 이미지로 렌더링되며 화면으로 출력된다.

---

위 과정을 다시 정리한다면

1. HTML 파일과 CSS 파일을 파싱해서 각각 Tree를 만든다. (Parsing)
2. 두 Tree를 결합하여 Rendering Tree를 만들며 최적화 과정을 거친다. (Style)
3. Rendering Tree에서 각 노드의 위치와 크기를 계산한다. (Layout)
4. 계산된 값을 이용해 각 노드를 화면상의 실제 픽셀로 변환하고, 레이어를 만든다. (Paint)
5. 레이어를 합성하여 실제 화면에 나타낸다 (Composite)

로 정리할 수 있다.
